﻿<%@ Control Language="C#" Inherits="System.Web.Mvc.ViewUserControl" %>
<% Ajax.RegisterClientScriptInclude(Url.Content("~/Content/Scripts/jquery-1.3.2.min.js")); %>
<% Ajax.RegisterCombinedScriptInclude(Url.Content("~/Content/Scripts/ajax.common.js"), "pmn"); %>
<div id="itineraryMail" class="off itineraryAddinBox">
<% using(Html.BeginForm("Email", "EmailItinerary")) %>
<% { %>
    <%=Html.AntiForgeryToken()%>
    <h3>Email Itinerary</h3>
    <p class="form">
        <% if (ViewData.ContainsKey("id")) { %><%=Html.Hidden("id", ViewData["id"]) %><% } %>
        <label for="email">Email:</label>
        <%=Html.TextBox("email")%>
        <input type="submit" value="Send" />
    </p>
    <p class="success off">
        Email sent succesfully.
    </p>
    <p class="error off">
        Ooops! An error occurred. Please <a class="retry" href="javascript:void(0)">try again</a>
    </p>
    <% if(Ajax.JavaScriptEnabled()) { %><span class="close" onclick="$('#itineraryMail').fadeOut()">Close</span><% } %>
<% } %>

<% Ajax.RegisterClientScriptBlock(
@"$(document).ready(function() {
    $('#emailItineraryLink, #itineraryMail a.retry').click(function(e) {
        $('#itineraryMail').fadeIn();
        $('#itineraryMail p.form').removeClass('off').removeClass('loading');
        $('#itineraryMail p.success, #itineraryMail p.error').addClass('off');
        $('#itineraryMail input[type=text]')[0].focus();
        return false;
    });
    
    updateModelOnFormSubmit(
        $('#itineraryMail form'),
        function(url) {
            $('#itineraryMail p.form').addClass('loading').css('height', '50px');
            return true;
        },
        function(data) {
            $('#itineraryMail p.form').css('height', null);
            $('#itineraryMail p.form').removeClass('loading').addClass('off');
            if(data && data.Status == 'Ok') {
                $('#itineraryMail p.success').removeClass('off');
            } else {
                // error
                $('#itineraryMail p.error').removeClass('off');
            }
        }
    );
});
"); %>
</div>